/////////////////////////////////////////////////////////////////////////////
// 
/////////////////////////////////////////////////////////////////////////////

/// 
uniform sampler2D uni_smp_intro ;
uniform sampler2D uni_smp_main ;
uniform sampler2D uni_smp_outro ;
uniform sampler2D uni_smp_ssao ;

/// Mixes intro and main with main only
uniform float uni_f_mix1 ;
/// Mixes the mix 1 with outro
uniform float uni_f_mix2 ;

void main()
{
	
	vec4 color_intro = texture2D(uni_smp_intro, gl_TexCoord[0].xy) ;	
	vec4 color_main = texture2D(uni_smp_main, gl_TexCoord[1].xy) ;	
	vec4 color_outro = texture2D(uni_smp_outro, gl_TexCoord[0].xy) ;	
	vec4 color_ssao = texture2D(uni_smp_ssao, gl_TexCoord[0].xy) ;

	// lets put some artistic color transformation onto the ssao buffer.
	color_main -= smoothstep(0.0,0.7, clamp(3.0*(vec4(1)-color_ssao),0.0,1.0)) ;
	//color_main -= smoothstep(0.0,1.0,3.0*(vec4(1)-color_ssao)) ;
	//color_main = smoothstep(0.0,1.0,(color_ssao)) ;

	vec4 color_intro_main = mix( color_main, color_intro, color_intro.a ) ;
	vec4 color_outro_main = mix( color_main, color_outro, color_outro.a ) ;

	
	vec4 color_mix1 = mix( color_intro_main, color_main, uni_f_mix1) ;
	vec4 color_mix2 = mix( color_mix1, color_outro_main, uni_f_mix2) ;


	gl_FragColor = color_mix2 ;
}